$(document).ready(function(){

	// change css when selecting a plan
	(function () {
		$('.signup__plan-opt').on('change', function(){
			$('.signup__plan-wrap.active').removeClass('active');
			$(this).parents('.signup__plan-wrap').addClass('active');
		});
	})();

	// show/hide extra address form
	(function () {
		$('#useBusinessAddress').on('change', function(){
			if ($(this).is(':checked')){
				$('#billingAddressForm input').prop('required', false);
				$('#billingAddressForm').hide();
			} else {
				$('#billingAddressForm input').prop('required', true);
				$('#billingAddressForm').show();
			}
		});
	})();

	// Business information 
	(function () {

		// fires a call back after x ms
		var delay = (function(){
		  var timer = 0;
		  return function(callback, ms){
		    clearTimeout (timer);
		    timer = setTimeout(callback, ms);
		  };
		})();

		var delay2 = (function(){
		  var timer = 0;
		  return function(callback, ms){
		    clearTimeout (timer);
		    timer = setTimeout(callback, ms);
		  };
		})();

		var delay3 = (function(){
		  var timer = 0;
		  return function(callback, ms){
		    clearTimeout (timer);
		    timer = setTimeout(callback, ms);
		  };
		})();	
		
	    function isEmailAvailable(email){
	     return $.ajax({
	        url: "api/api.check-merchant-email.php",
	        global: false,
	        type: "POST", 
	        dataType: "HTML",      
	        data:  "ltb_email="+email
	      });
	    }

		var emailTaken = 0;
	    $('#ltb_email, #ema_ltb_email_r').on('change keyup', function() {
	    	var promise = isEmailAvailable($(this).val());
	    	delay(function(){
				promise.success(function (data) {
					if (data === 'Taken'){
				    	emailTaken = 1;
				    	$('#ltb_email, #ema_ltb_email_r').tooltip({
			    			placement: 'bottom',
			    			title: 'Email already registered',
			    			trigger: 'manual' 
			    		}).tooltip('show');
				    } else {
				    	emailTaken = 0;
				    	$('#ltb_email, #ema_ltb_email_r').tooltip('destroy');
				    }
				});
			}, 300);
	    });

	    var emailsMatch = 0;
		$('#ltb_email2, #ltb_email').on('change keyup blur', function(){
			if ($('#ltb_email2').val() !== ''){
				delay2(function(){
					if ($('#ltb_email2').val().toLowerCase() !== $('#ltb_email').val().toLowerCase()){
						emailsMatch = 0;
						$('#ltb_email2').tooltip({
			    			placement: 'bottom',
			    			title: 'Emails must match',
			    			trigger: 'manual' 
			    		}).tooltip('show');
					} else {
						emailsMatch = 1;
						$('#ltb_email2').tooltip('destroy');
					}
				}, 300);
			}
		});

		var passwordsMatch = 0;
		$('#psw_ltb_password_r, #psw_ltb_password2_r').on('change keyup blur', function(){
			delay3(function(){
				if ($('#psw_ltb_password_r').val() !== $('#psw_ltb_password2_r').val()){
					passwordsMatch = 0;
					$('#psw_ltb_password2_r').tooltip({
		    			placement: 'bottom',
		    			title: 'Passwords must match',
		    			trigger: 'manual' 
		    		}).tooltip('show');
				} else {
					passwordsMatch = 1;
					$('#psw_ltb_password2_r').tooltip('destroy');
				}
			}, 300);
		});		

		var testForm = new validateForm();
		var searchBusinessSubmit = $('#searchBusinessSubmit');

		function scrollToTop(){
			return document.body.scrollTop = document.documentElement.scrollTop = 0;
		}

		function check_form(formObj){
			testForm.inicialiceObj($(formObj));    
			if (!testForm.validInputs(false)){   
				$('#formErrors').html(testForm.buildMessage());
				scrollToTop();
				return false;
			} else {
				$('#formErrors').html('');
			}
			return true;
		}

		// submit merchant signup
		$('#businessAddressForm').on('submit', function(e){
			e.preventDefault();
			$('#businessAddressForm button[type="submit"]').prop('disabled', true).text('Working...');
			if (check_form($(this)) && !emailTaken && passwordsMatch){
				$('*').tooltip('destroy');
				// submit ajax
				// console.log($(this).serializeArray());
				$.ajax({
					url: "reseller/app/view/inc/signup.process-form-v1.php",
					global: false,
					type: "POST", 
					dataType: "json",      
					data:  $(this).serializeArray(),
					error: function (response){ console.error('error!!', response); },
					success: function (response){
						//console.log(response);
						if (response.status == 'success'){
							// console.log(response.status);
							window.location = "/signup?step=3";
						} else {
							$('#formErrors').html('<div class="alert alert-danger"><span class="glyphicon glyphicon-exclamation-sign"></span> Review errors below</div>');
							scrollToTop();
							// console.log(response.error);
							$.each(response.error, function(key, value){
					    		$('[name='+key+']').tooltip({
					    			placement: 'bottom',
					    			title: value,
					    			trigger: 'manual' 
					    		}).tooltip('show');
					    	});
							$('#businessAddressForm button[type="submit"]').prop('disabled', false).text('Continue');
						}
					}
				});
			} else {
				$('#businessAddressForm button[type="submit"]').prop('disabled', false).text('Continue');
			}
		});

		var searchDotsInterval;
		// search business
		$('#searchBusinessForm').on('submit', function(e){
			e.preventDefault();
			searchBusinessSubmit.prop('disabled', true).text('Working...');
			if (check_form($(this)) && !emailTaken && emailsMatch){
				//submit form
				$(this).hide();
				$('#search-prog').html('Searching business database<span id="search-dots">...</span>');
				var searchDots = $('#search-dots');
				searchDotsInterval = window.setInterval(function(){
					if (searchDots.html().length < 3){
						searchDots.html(searchDots.html()+'.');
					} else {
						searchDots.html('');
					}
				}, 300);

				var bizArray = {};
				var unformattedBizArray = $(this).serializeArray();

				$.each(unformattedBizArray, function(){
					if (bizArray[this.name] !== undefined) {
			            if (!bizArray[this.name].push) {
			                bizArray[this.name] = [bizArray[this.name]];
			            }
			            bizArray[this.name].push(this.value || '');
			        } else {
			            bizArray[this.name] = this.value || '';
			        }
				});

				// console.log(bizArray);
				if (google !== undefined){ //loading google maps API occasionally fails
					searchGoogle(bizArray);
				} else {
					resultsNotFound(bizArray);
				}
				
			} else {
				searchBusinessSubmit.prop('disabled', false).text('Continue');
			}
		});

		function resultsNotFound(bizInfo){
		  	$.each(bizInfo, function(key, value){
	    		$('[name='+key+']').val(value);
	    	});
	    	$('#searchBusinessWrap').hide();
	    	$('#businessAddressForm').show();
		  }

		function searchGoogle(bizInfo){
		  var user_zipcode = bizInfo.zip_ltm_zipcode_r;
		  var user_bizname = bizInfo.txt64_ltm_company_name_r;
		  var user_phone = bizInfo.pho_ltm_phone_number_r;
		  bizInfo.nam_cc_cardholder_r = bizInfo.nam_ltb_contact_first_name_r +' '+bizInfo.nam_ltb_contact_last_name_r;
		  var geocoder;
		  var map;
		  var service;
		  var searchRadius = 5000;
		  function initialize() {
		    //begin google maps/places API initialization
		    geocoder = new google.maps.Geocoder();
		    //call codeAddress to convert user zip code to lat long values
		    codeAddress();
		  }
		  function codeAddress() {
		    // get lat and lng coords from zipcode
		    geocoder.geocode( { 'address': user_zipcode}, function(results, status) {
		      if (status == google.maps.GeocoderStatus.OK) {
		        // set lat and lng values to variable names
		        var xlat = results[0].geometry.location.lat();
		        var xlng = results[0].geometry.location.lng();

		        bizInfo.dec_ltm_lat_r = results[0].geometry.location.lat();
		        bizInfo.dec_ltm_lng_r = results[0].geometry.location.lng();

		        // group the lat and lng values into a format google.maps api can work with
		        var latlng = new google.maps.LatLng(xlat, xlng);
		        // since codeAddress values are returned asynchronously: send lat and lng values to initContinued() and continue from there 
		        initContinued(latlng);
		      } else {
		        // geocode failed, cannot find lat and lng from the zipcode input
		        // alert('Geocode was not successful for the following reason: ' + status);
		        $('#searchBusinessForm').show();
		        $('#search-prog').html('Bad zip code, try again.'); 
		        searchBusinessSubmit.prop('disabled', false).text('Continue');
		        window.clearInterval(searchDotsInterval);
		      }
		    });
		  }
		  function initContinued(coords) {
		    // set map options, even though the map doesn't display, there needs to be a map object created
		    var mapOptions = { center: coords }
		    // create map object
		    map = new google.maps.Map(document.getElementById('map-canvas'), mapOptions);
		    // setting search request variables: 
		    // location is set to the coordinates we got from the geocode process, 
		    // the radius was arbitrarily set to 5000, 
		    // keyword is the business name from the user input
		    var request = { location: coords, radius: searchRadius, keyword: user_bizname };
		    // google places nearbySearch object
		    service = new google.maps.places.PlacesService(map);
		    service.nearbySearch(request, callback);
		  }
		  function callback(results, status) {
		    if (status == google.maps.places.PlacesServiceStatus.OK) {         
		      var resultsPrinted = 0;
		      var manualCount = 0;
		      for (var i = 0; i < results.length; i++) {

		        // create nearbySearch results object named place
		        var place = results[i];

		        // since nearbySearch function does not return the phone number and other specific details by default,
		        // use the result's placeID to get the businesses details such as phone number and formatted address
		        var request = { placeId: place.place_id };

		        service.getDetails(request, function(details, status) {
		        	if (details !== null){
			          // make ajax call to check-place-id API        
			          $.ajax({
			            // check if the result's Google ID matches one of the Google ID's in our database, if so, display a "Claimed Already" message
			            url: "api/api.check-place-ID.php",
			            global: false,
			            type: "POST",       
			            dataType: "JSON",
			            data:  "google_id="+details.place_id,
			            success: function (response){

			              
			              var bizAlreadyClaimed = response;

			              // //console.log(addressArray[0]);
			              // set search result's phone number to placenum
			              var placenum = (details.formatted_phone_number ? details.formatted_phone_number.replace(/[^\d]+/g, '') : '');
			              // set phone number input by user to searchnum
			              var searchnum = user_phone.replace(/[^\d]+/g, '');
			              // check if user added a 1 to the beginning of their phone number, if so, remove it
			              if (searchnum.charAt(0) === "1") {searchnum = searchnum.replace('1', '');}
			              // if the phone numbers match, we have our top match
			              if (placenum === searchnum) {

							// splitting address on , to get different address parts
							addressArray = details.formatted_address.split(',');
							// single line street address
							addressStreet = addressArray[0];
							// city
							addressCity = addressArray[1].trim();
							// splitting the state and zip code on ' ' to separate them into two parts
							addressStateZip = addressArray[2].trim().split(' ');
							// set addressState to the first part 
							addressState = addressStateZip[0];
							// set addressZip to the second part
							addressZip = addressStateZip[1];

							var claimBizForm = '<div id="choose-line"><input type="checkbox" id="terms-box"> <label for="terms-box">I certify this is my business & Accept Local Thanks℠ <a href="terms" target="_blank">Terms of Service</a></label></div>\
							<div class="matched-wrap">\
							<div class="matched-biz-name"><strong>' + details.name + '</strong></div>\
							<div class="matched-wrap-inner row">\
							<ul class="matched-details col-sm-8"><li>' + addressStreet +' '+ addressCity +' '+ addressState +' '+ addressZip +'</li>\
							<li>' + details.formatted_phone_number + '</li>\
							</ul>';
							if (bizAlreadyClaimed==0){
								claimBizForm +='<div class="col-xs-12 col-sm-4"><button type="button" class="btn btn-success form-control" id="claimBusinessBtn">Claim</button></div>';
							} else {
								claimBizForm +='<div style="font-size: .8em;">This business has already been claimed, log in to <a href="/mystore" target="_blank" style="color: #fff;">MyStore</a> to manage your page.</div>';
							}
							claimBizForm += '</div></div>';
							claimBizForm += '<br><button type="button" class="btn btn-danger btn-sm" id="wrongBusinessFound">This Is Not My Business</button>';
				            window.clearInterval(searchDotsInterval);
				            resultsPrinted = 1;
		        			$('#search-prog').html('We found a matching business: ');
			                $('#search-results').show();
			                // add claim button/hidden form
			                $('#search-results').append(claimBizForm);

			                $('#claimBusinessBtn').on('click', function() {
							    if (!$("#terms-box").is(":checked") ){
							      event.preventDefault();
							      alert('Please check the Terms and Conditions box.');
							    } else {
									bizInfo.txt64_ltm_google_id = details.place_id;
									bizInfo.txt64_ltm_company_name_r = details.name;
									bizInfo.txt_ltm_address_r = addressStreet;
									bizInfo.nam_ltm_city_r =  addressCity;
									bizInfo.abc_ltm_state_r = addressState,
									bizInfo.zip_ltm_zipcode_r = addressZip,
									bizInfo.pho_ltm_phone_number_r = details.formatted_phone_number.replace(/[^\d]+/g, '');
							    	$.each(bizInfo, function(key, value){
							    		$('[name='+key+']').val(value);
							    	});
							    	$('#searchBusinessWrap').hide();
							    	$('#businessAddressForm').show();
							    }
			                });
			                $('#wrongBusinessFound').on('click', function(){
			                	resultsNotFound(bizInfo);
			                });
			                window.clearInterval(checkResults);
			              }			
			              manualCount++;	  		
			            }//end ajax callback function
			          });//end ajax call
					} else {
						manualCount++;
					}
		         });//end service.getDetails
		      }
				
			checkResults = window.setInterval(function(){
				// this code deals with the double AJAX calls getDetails && check places api
				// returning at different times and in different orders
				// check if we've printed a result and all the AJAX calls have returned
				if (resultsPrinted == 0 && i == manualCount){
					resultsNotFound(bizInfo);
					window.clearInterval(checkResults);
		        }
			}, 300);

		    } else { 
		      // no results were found
		      resultsNotFound(bizInfo); 
		    }
		  }
		  initialize();
		}

	})();


});